RangeBarStamp = function(canvas, rect, rangeMin, rangeMax, valueMin, valueMax, backgroundPaint, paint)
    canvas:setPaint(backgroundPaint):fill(Path.rect(rect))
    valueMin, valueMax = tonumber(valueMin), tonumber(valueMax)
    if valueMin and valueMax then
        rect.left, rect.right = rect:mapPointX((valueMin - rangeMin) / (rangeMax - rangeMin)), rect:mapPointX((valueMax - rangeMin) / (rangeMax - rangeMin))
        canvas:setPaint(paint):fill(Path.rect(rect))
    end
end

return RangeBarStamp
